<?php

// Include the main TCPDF library (search for installation path).
require_once('tcpdf_include.php');

// create new PDF document
$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

// set document information
$pdf->SetCreator(PDF_CREATOR);
//$pdf->SetAuthor('Nicola Asuni');
$pdf->SetTitle('Karta Pracy');
$pdf->SetSubject('Karta Pracy');
//$pdf->SetKeywords('TCPDF, PDF, example, test, guide');

// set default header data
$pdf->SetHeaderData('logo.png', 50, '', '');

// set header and footer fonts
$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

// set default monospaced font
$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

// set margins
$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

// set auto page breaks
$pdf->SetAutoPageBreak(FALSE, PDF_MARGIN_BOTTOM);

// set image scale factor
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

$pdf->setPageUnit('mm');

// set some language-dependent strings (optional)
if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
    require_once(dirname(__FILE__).'/lang/eng.php');
    $pdf->setLanguageArray($l);
}

// -------------------------------------------------------------------

// add a page
$pdf->AddPage();


$html = '<h2 style="font-size:18px; color:#cc005b;">'.$_POST['nazwa'].'</h2>';
$pdf->writeHTML($html, true, false, true, false, '');

// set JPEG quality
$pdf->setJPEGQuality(100);

// Image method signature:
// Image($file, $x='', $y='', $w=0, $h=0, $type='', $link='', $align='', $resize=false, $dpi=300, $palign='', $ismask=false, $imgmask=false, $border=0, $fitbox=false, $hidden=false, $fitonpage=false)

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -




$list_img = $_POST['list_img'];

$tab_img = explode(';', $list_img);			
			
// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

$wys_cursor = 40;


foreach($tab_img AS $key => $val){
	
	
		$ext = substr($val, strpos($val, '.'));
		if($ext == '.png'){
			$pdf->Image('../../podrecznik/zadania_img/'.$val, 10, $wys_cursor, 190, 0, 'PNG', '', '', false, 600, 'L', false, false, 0, false, false, false);
		}else{
			$pdf->Image('../../podrecznik/zadania_img/'.$val, 10, $wys_cursor, 190, 0, 'JPG', '', '', false, 600, 'L', false, false, 0, false, false, false);
		}
		
		list($width, $height, $type, $attr) = getimagesize("../../podrecznik/zadania_img/$val");
		
		$wys_cursor +=($height/23.63)+25;
	
		if(($wys_cursor + (($height/23.63)+25)) > 290){
			$wys_cursor = 40;
			$pdf->AddPage();
		}

}




//Close and output PDF document
$pdf->Output('karta_pracy', 'I');

//============================================================+
// END OF FILE
//============================================================+